# Backend Deployment Guide for StormerHost

## Pre-Deployment Checklist

### 1. Files to Upload
Upload the following directories and files to your StormerHost server:

```
backend/
├── api/
│   ├── index.php (Main API entry point)
│   ├── config.php (Configuration)
│   ├── .htaccess (API routing)
│   ├── middleware/
│   │   └── cors.php
│   └── handlers/
│       ├── academic.php
│       ├── assessments_extended.php
│       ├── fuel_logs.php
│       ├── scores.php
│       ├── sms.php
│       ├── subjects.php
│       ├── transport.php
│       ├── transport_attendance.php
│       └── transport_payments.php
├── config/
│   ├── database.php
│   └── db_config.php
├── database/ (Optional - for migrations/setup)
└── .htaccess (Root configuration)
```

### 2. Files to EXCLUDE (Do NOT upload)
- `test*.php` files (test_feeding.php, test_server.php, test.php, etc.)
- `quick-test.php`, `cors-test.php`
- `index_clean.php` (backup/cleanup file)
- Development files in `database/` folder (unless you need to run migrations)

### 3. Directory Structure on StormerHost

Recommended structure:
```
/public_html/
├── school/              (If you want /school path)
│   ├── api/
│   │   ├── index.php
│   │   ├── config.php
│   │   ├── .htaccess
│   │   └── handlers/
│   ├── database/
│   └── .htaccess
```

OR if deploying directly to root:
```
/public_html/
├── api/
│   ├── index.php
│   ├── config.php
│   ├── .htaccess
│   └── handlers/
└── .htaccess
```

## Configuration Steps

### Step 1: Update Database Configuration

Edit `backend/api/config.php` and verify/update these values for your StormerHost database:

```php
// Database configuration - Production
define('DB_HOST', 'localhost');  // Usually 'localhost' for StormerHost
define('DB_NAME', 'your_database_name');  // Your StormerHost database name
define('DB_USER', 'your_db_username');    // Your StormerHost database user
define('DB_PASS', 'your_db_password');    // Your StormerHost database password
```

**To get your database credentials:**
1. Login to your StormerHost cPanel
2. Go to "MySQL Databases"
3. Note your database name, username, and password

### Step 2: Verify Server Detection

The config automatically detects production. Make sure your domain is recognized:

```php
$isProduction = strpos($serverName, 'ceiscy.com') !== false || 
               strpos($serverName, '4102009823.ceiscy.com') !== false ||
               strpos($serverName, 'dgsch.vercel.app') !== false;
```

**If your StormerHost domain is different**, add it here:
```php
$isProduction = strpos($serverName, 'your-domain.com') !== false || ...
```

### Step 3: Set File Permissions

Via FTP/cPanel File Manager, set these permissions:

```
api/                  -> 755 (or 750)
api/handlers/         -> 755
api/middleware/       -> 755
api/index.php         -> 644
api/config.php        -> 644
api/.htaccess         -> 644
logs/                 -> 755 (will be created automatically)
```

**To set permissions via cPanel:**
1. Go to File Manager
2. Right-click on folder/file
3. Select "Change Permissions"
4. Set the numeric value

### Step 4: Create Logs Directory

The system will auto-create this, but you can manually create it:

1. Create directory: `backend/logs/` (or `api/logs/`)
2. Set permissions to 755
3. Create `.htaccess` inside with: `Deny from all`

### Step 5: Test API Endpoint

After upload, test if the API is working:

**Test URL:**
```
https://your-domain.com/school/api/test
```

**OR if deployed to root:**
```
https://your-domain.com/api/test
```

**Expected Response:**
```json
{
  "success": true,
  "message": "API is working!",
  "timestamp": "2024-01-01 12:00:00",
  "endpoint": "test",
  "method": "GET"
}
```

## StormerHost-Specific Configuration

### Apache/.htaccess Requirements

Make sure your StormerHost plan supports:
- ✅ `.htaccess` files
- ✅ `mod_rewrite` (for URL routing)
- ✅ `mod_headers` (for CORS)
- ✅ PHP 7.4 or higher
- ✅ PDO MySQL extension

**To check PHP version:**
1. Create a test file: `phpinfo.php` with `<?php phpinfo(); ?>`
2. Access it via browser
3. Check PHP version and extensions

### PHP Requirements

Your server needs:
- PHP 7.4+ (PHP 8.0+ recommended)
- PDO extension enabled
- cURL extension enabled (for SMS)
- `allow_url_fopen` enabled (for SMS API)

**To check in cPanel:**
1. Go to "Select PHP Version"
2. Enable required extensions
3. Set PHP version to 7.4 or higher

## API URL Configuration

### Current Setup
- **Frontend (Vercel):** https://dgsch.vercel.app/
- **Backend API:** https://pcg.campus-plug.com/backend/api

### After Deployment to StormerHost

If your StormerHost domain is different, update the frontend:

In `frontend/src/services/api.js`, update:
```javascript
if (window.location.hostname === 'dgsch.vercel.app') {
  return 'https://your-stormerhost-domain.com/backend/api';
}
```

## Troubleshooting

### Issue: 500 Internal Server Error

**Solutions:**
1. Check PHP error logs in cPanel
2. Verify `.htaccess` syntax is correct
3. Check file permissions (644 for files, 755 for folders)
4. Ensure `mod_rewrite` is enabled

### Issue: CORS Errors

**Solutions:**
1. Verify `.htaccess` CORS headers are set
2. Check `backend/api/middleware/cors.php` includes your domain
3. Ensure `mod_headers` is enabled on Apache

### Issue: Database Connection Failed

**Solutions:**
1. Verify database credentials in `config.php`
2. Check database host (may need IP instead of 'localhost')
3. Verify database user has proper permissions
4. Test connection via phpMyAdmin

### Issue: 404 Not Found on API Calls

**Solutions:**
1. Verify `.htaccess` rewrite rules are working
2. Check if `mod_rewrite` is enabled
3. Ensure correct path structure (e.g., `/school/api/`)
4. Test with direct path: `/api/index.php?endpoint=test`

## Post-Deployment Steps

1. ✅ Test API endpoint: `https://your-domain.com/api/test`
2. ✅ Test authentication: `POST /api/auth`
3. ✅ Test database connection via any endpoint
4. ✅ Verify CORS works from frontend
5. ✅ Test SMS functionality (if needed)
6. ✅ Monitor error logs for issues

## Security Recommendations

1. ✅ Remove test files from production
2. ✅ Set `display_errors = 0` in PHP config (already in code)
3. ✅ Protect `logs/` directory (already has `.htaccess`)
4. ✅ Use strong database passwords
5. ✅ Regularly update JWT_SECRET in `index.php`
6. ✅ Keep PHP and extensions updated

## Support Files

If you need to run database migrations:
- Upload `database/` folder
- Run setup scripts via browser: `https://your-domain.com/database/setup_complete_database.php`
- **Remove database folder after setup** for security

## Quick Upload Checklist

- [ ] Upload `api/` directory
- [ ] Upload `config/` directory  
- [ ] Upload `.htaccess` files
- [ ] Update database credentials in `config.php`
- [ ] Set correct file permissions
- [ ] Test API endpoint
- [ ] Remove test files
- [ ] Update frontend API URLs (if domain changed)
- [ ] Test full functionality

---

**Need Help?**
- Check StormerHost documentation
- Review PHP error logs in cPanel
- Test API endpoints individually
- Verify all extensions are enabled

