<?php
// Production error handling - log errors but don't display
ini_set('display_errors', 0); // Disabled for production security
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/php_errors.log');
error_reporting(E_ALL);

// Set timezone
date_default_timezone_set('UTC');

// Check if we're in production
$serverName = $_SERVER['SERVER_NAME'] ?? $_SERVER['HTTP_HOST'] ?? 'localhost';
$isProduction = strpos($serverName, 'ceiscy.com') !== false || 
               strpos($serverName, '4102009823.ceiscy.com') !== false ||
               strpos($serverName, 'dgsch.vercel.app') !== false ||
               strpos($serverName, 'pcg.campus-plug.com') !== false;

// Database configuration - Production (StormerHost)
define('DB_HOST', 'localhost');
define('DB_NAME', 'campuspl_dgsch');
define('DB_USER', 'campuspl_pcg');
define('DB_PASS', 'pcgcctt@30');

// API configuration
define('API_DEBUG', false); // Disabled for production security

// SMS Configuration (Mnotify)
define('SMS_API_KEY', 'J2rI5TXxDosrbwlmNyoPbwtK6');
define('SMS_SENDER_ID', 'SoNice');
define('SMS_API_URL', 'https://api.mnotify.com/api/sms/quick');

// Create logs directory if it doesn't exist
$logDir = __DIR__ . '/../logs';
if (!is_dir($logDir)) {
    mkdir($logDir, 0755, true);
    file_put_contents($logDir . '/.htaccess', 'Deny from all');
}

// Function to handle database connection errors
function handleDatabaseError($e) {
    error_log("Database Error: " . $e->getMessage());
    if (defined('API_DEBUG') && API_DEBUG) {
        http_response_code(500);
        die(json_encode([
            'status' => 'error',
            'message' => 'Database connection failed: ' . $e->getMessage(),
            'debug' => defined('API_DEBUG') && API_DEBUG ? [
                'host' => DB_HOST,
                'dbname' => DB_NAME,
                'user' => DB_USER,
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ] : null
        ]));
    } else {
        http_response_code(500);
        die(json_encode([
            'status' => 'error',
            'message' => 'Internal server error'
        ]));
    }
}