<?php

function handleScores($conn, $method) {
    switch($method) {
        case 'GET':
            try {
                $studentId = $_GET['student_id'] ?? null;
                $subjectId = $_GET['subject_id'] ?? null;
                
                $query = "SELECT s.*, st.name as student_name, sub.name as subject_name 
                         FROM scores s 
                         JOIN students st ON s.student_id = st.id 
                         JOIN subjects sub ON s.subject_id = sub.id";
                
                $params = [];
                if ($studentId) {
                    $query .= " WHERE s.student_id = ?";
                    $params[] = $studentId;
                }
                if ($subjectId) {
                    $query .= $studentId ? " AND" : " WHERE";
                    $query .= " s.subject_id = ?";
                    $params[] = $subjectId;
                }
                
                $stmt = $conn->prepare($query);
                $stmt->execute($params);
                $scores = $stmt->fetchAll();
                echo json_encode(['success' => true, 'data' => $scores]);
            } catch (PDOException $e) {
                http_response_code(500);
                echo json_encode(['success' => false, 'error' => 'Failed to fetch scores']);
            }
            break;

        case 'POST':
            try {
                $data = json_decode(file_get_contents('php://input'), true);
                
                // Validate required fields
                $requiredFields = ['student_id', 'subject_id', 'score', 'term', 'school_year'];
                foreach ($requiredFields as $field) {
                    if (!isset($data[$field])) {
                        throw new Exception("Missing required field: $field");
                    }
                }
                
                // Validate score range
                if ($data['score'] < 0 || $data['score'] > 100) {
                    throw new Exception('Score must be between 0 and 100');
                }

                $stmt = $conn->prepare("INSERT INTO scores (student_id, subject_id, score, term, school_year, remarks) 
                                      VALUES (?, ?, ?, ?, ?, ?)");
                $stmt->execute([
                    $data['student_id'],
                    $data['subject_id'],
                    $data['score'],
                    $data['term'],
                    $data['school_year'],
                    $data['remarks'] ?? null
                ]);
                echo json_encode(['success' => true, 'message' => 'Score recorded']);
            } catch (Exception $e) {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => $e->getMessage()]);
            }
            break;

        case 'PUT':
            try {
                $data = json_decode(file_get_contents('php://input'), true);
                if (!isset($data['id'])) {
                    throw new Exception('Score ID is required');
                }

                // Validate score range
                if (isset($data['score']) && ($data['score'] < 0 || $data['score'] > 100)) {
                    throw new Exception('Score must be between 0 and 100');
                }

                $stmt = $conn->prepare("UPDATE scores SET score = ?, remarks = ? WHERE id = ?");
                $stmt->execute([$data['score'], $data['remarks'] ?? null, $data['id']]);
                echo json_encode(['success' => true, 'message' => 'Score updated']);
            } catch (Exception $e) {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => $e->getMessage()]);
            }
            break;

        case 'DELETE':
            try {
                $id = $_GET['id'] ?? null;
                if (!$id) {
                    throw new Exception('Score ID is required');
                }
                $stmt = $conn->prepare("DELETE FROM scores WHERE id = ?");
                $stmt->execute([$id]);
                echo json_encode(['success' => true, 'message' => 'Score deleted']);
            } catch (Exception $e) {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => $e->getMessage()]);
            }
            break;

        default:
            http_response_code(405);
            echo json_encode(['success' => false, 'error' => 'Method not allowed']);
            break;
    }
}