<?php
/**
 * Handle transport attendance
 */
function handleTransportAttendance($conn, $method) {
    $id = $_GET['id'] ?? null;
    
    try {
        switch($method) {
            case 'GET':
                $date = $_GET['date'] ?? date('Y-m-d');
                $routeId = $_GET['route_id'] ?? null;
                $shift = $_GET['shift'] ?? null;
                
                $where = ["attendance_date = ?"];
                $params = [$date];
                
                if ($routeId) {
                    $where[] = "route_id = ?";
                    $params[] = $routeId;
                }
                
                if ($shift) {
                    $where[] = "shift = ?";
                    $params[] = $shift;
                }
                
                $whereClause = implode(' AND ', $where);
                
                $stmt = $conn->prepare("
                    SELECT ta.*, 
                           CONCAT(s.first_name, ' ', s.last_name) as student_name,
                           s.class, r.route_name, v.vehicle_number
                    FROM transport_attendance ta
                    JOIN students s ON ta.student_id = s.student_id
                    JOIN transport_routes r ON ta.route_id = r.route_id
                    JOIN transport_vehicles v ON ta.vehicle_id = v.vehicle_id
                    WHERE $whereClause
                    ORDER BY ta.boarding_time
                ");
                $stmt->execute($params);
                echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
                break;

            case 'POST':
                $data = json_decode(file_get_contents('php://input'), true);
                
                if (empty($data['student_id']) || empty($data['route_id']) || empty($data['vehicle_id'])) {
                    http_response_code(400);
                    echo json_encode(['error' => 'Student ID, route ID, and vehicle ID are required']);
                    return;
                }
                
                $stmt = $conn->prepare("
                    INSERT INTO transport_attendance (student_id, route_id, vehicle_id, attendance_date, shift, 
                        boarded, boarding_time, alighted, alighting_time, stop_id, recorded_by, notes)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                    ON DUPLICATE KEY UPDATE 
                        boarded = VALUES(boarded),
                        boarding_time = VALUES(boarding_time),
                        alighted = VALUES(alighted),
                        alighting_time = VALUES(alighting_time)
                ");
                
                $stmt->execute([
                    $data['student_id'],
                    $data['route_id'],
                    $data['vehicle_id'],
                    $data['attendance_date'] ?? date('Y-m-d'),
                    $data['shift'] ?? 'morning',
                    $data['boarded'] ?? false,
                    $data['boarding_time'] ?? null,
                    $data['alighted'] ?? false,
                    $data['alighting_time'] ?? null,
                    $data['stop_id'] ?? null,
                    $data['recorded_by'] ?? null,
                    $data['notes'] ?? null
                ]);
                
                http_response_code(201);
                echo json_encode(['success' => true, 'id' => $conn->lastInsertId()]);
                break;
                
            case 'PUT':
                if (!$id) {
                    http_response_code(400);
                    echo json_encode(['error' => 'Attendance ID is required']);
                    return;
                }
                
                $data = json_decode(file_get_contents('php://input'), true);
                $updates = [];
                $params = [];
                $allowedFields = ['boarded', 'boarding_time', 'alighted', 'alighting_time', 'notes'];
                
                foreach ($data as $key => $value) {
                    if (in_array($key, $allowedFields)) {
                        $updates[] = "$key = ?";
                        $params[] = $value;
                    }
                }
                
                if (empty($updates)) {
                    http_response_code(400);
                    echo json_encode(['error' => 'No valid fields to update']);
                    return;
                }
                
                $params[] = $id;
                $stmt = $conn->prepare("UPDATE transport_attendance SET " . implode(', ', $updates) . " WHERE attendance_id = ?");
                $stmt->execute($params);
                
                echo json_encode(['success' => true]);
                break;
                
            default:
                http_response_code(405);
                echo json_encode(['error' => 'Method not allowed']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    }
}
