<?php
/**
 * Handle transport payments
 */
function handleTransportPayments($conn, $method) {
    $id = $_GET['id'] ?? null;
    
    try {
        switch($method) {
            case 'GET':
                if ($id) {
                    $stmt = $conn->prepare("
                        SELECT tp.*, 
                               CONCAT(s.first_name, ' ', s.last_name) as student_name,
                               s.class, st.route_id, r.route_name
                        FROM transport_payments tp
                        JOIN students s ON tp.student_id = s.student_id
                        JOIN student_transport st ON tp.transport_registration_id = st.transport_registration_id
                        JOIN transport_routes r ON st.route_id = r.route_id
                        WHERE tp.payment_id = ?
                    ");
                    $stmt->execute([$id]);
                    echo json_encode($stmt->fetch(PDO::FETCH_ASSOC));
                } else {
                    $studentId = $_GET['student_id'] ?? null;
                    $where = $studentId ? "WHERE tp.student_id = ?" : "";
                    $params = $studentId ? [$studentId] : [];
                    
                    $stmt = $conn->prepare("
                        SELECT tp.*, 
                               CONCAT(s.first_name, ' ', s.last_name) as student_name,
                               s.class, r.route_name
                        FROM transport_payments tp
                        JOIN students s ON tp.student_id = s.student_id
                        JOIN student_transport st ON tp.transport_registration_id = st.transport_registration_id
                        JOIN transport_routes r ON st.route_id = r.route_id
                        $where
                        ORDER BY tp.payment_date DESC
                    ");
                    $stmt->execute($params);
                    echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
                }
                break;

            case 'POST':
                $data = json_decode(file_get_contents('php://input'), true);
                
                if (empty($data['student_id']) || empty($data['transport_registration_id']) || empty($data['amount_paid'])) {
                    http_response_code(400);
                    echo json_encode(['error' => 'Student ID, registration ID, and amount are required']);
                    return;
                }
                
                // Generate receipt number
                $receiptNumber = 'TR-' . date('Ymd') . '-' . strtoupper(substr(uniqid(), -6));
                
                $stmt = $conn->prepare("
                    INSERT INTO transport_payments (student_id, transport_registration_id, amount_paid, payment_date, 
                        payment_method, period_from, period_to, balance, receipt_number, recorded_by, notes)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                ");
                
                $stmt->execute([
                    $data['student_id'],
                    $data['transport_registration_id'],
                    $data['amount_paid'],
                    $data['payment_date'] ?? date('Y-m-d'),
                    $data['payment_method'] ?? 'cash',
                    $data['period_from'] ?? date('Y-m-d'),
                    $data['period_to'] ?? date('Y-m-d', strtotime('+1 month')),
                    $data['balance'] ?? 0,
                    $receiptNumber,
                    $data['recorded_by'] ?? null,
                    $data['notes'] ?? null
                ]);
                
                $paymentId = $conn->lastInsertId();
                $stmt = $conn->prepare("SELECT * FROM transport_payments WHERE payment_id = ?");
                $stmt->execute([$paymentId]);
                
                http_response_code(201);
                echo json_encode($stmt->fetch(PDO::FETCH_ASSOC));
                break;
                
            case 'PUT':
                if (!$id) {
                    http_response_code(400);
                    echo json_encode(['error' => 'Payment ID is required']);
                    return;
                }
                
                $data = json_decode(file_get_contents('php://input'), true);
                $updates = [];
                $params = [];
                $allowedFields = ['amount_paid', 'payment_date', 'payment_method', 'balance', 'notes'];
                
                foreach ($data as $key => $value) {
                    if (in_array($key, $allowedFields)) {
                        $updates[] = "$key = ?";
                        $params[] = $value;
                    }
                }
                
                if (empty($updates)) {
                    http_response_code(400);
                    echo json_encode(['error' => 'No valid fields to update']);
                    return;
                }
                
                $params[] = $id;
                $stmt = $conn->prepare("UPDATE transport_payments SET " . implode(', ', $updates) . " WHERE payment_id = ?");
                $stmt->execute($params);
                
                $stmt = $conn->prepare("SELECT * FROM transport_payments WHERE payment_id = ?");
                $stmt->execute([$id]);
                echo json_encode($stmt->fetch(PDO::FETCH_ASSOC));
                break;
                
            default:
                http_response_code(405);
                echo json_encode(['error' => 'Method not allowed']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
    }
}
