<?php
function handleCORS() {
    // Get the origin of the request
    $http_origin = $_SERVER['HTTP_ORIGIN'] ?? '';
    
    // List of allowed origins
    // Updated allowed origins for Vercel deployment
    $allowedOrigins = [
        'https://dgsch.vercel.app',  // Primary Vercel frontend
        'https://4102009823.ceiscy.com',  // StormerHost production
        'http://4102009823.ceiscy.com',   // StormerHost HTTP
        'http://localhost:3000',          // React dev server
        'http://localhost:3001',          // Alternative React dev server
        'http://localhost:3002',          // Alternative React dev server
        'http://localhost:5173',          // Vite dev server
        'http://localhost:5174',          // Alternative Vite dev server
        'http://127.0.0.1:3000',          // React dev server (IP)
        'http://127.0.0.1:5173'           // Vite dev server (IP)
    ];
    
    // Always set CORS headers first
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
    header('Access-Control-Max-Age: 86400');
    
    // Set origin-specific headers
    if (!empty($http_origin) && in_array($http_origin, $allowedOrigins)) {
        header("Access-Control-Allow-Origin: $http_origin");
        header('Access-Control-Allow-Credentials: true');
    } else {
        // For development, be more permissive
        if (strpos($http_origin, 'localhost') !== false || strpos($http_origin, '127.0.0.1') !== false) {
            header("Access-Control-Allow-Origin: $http_origin");
            header('Access-Control-Allow-Credentials: true');
        } else {
            // For production or unknown origins, allow all for now
            header('Access-Control-Allow-Origin: *');
        }
    }
    
    // Handle preflight OPTIONS request - MUST exit immediately
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200); // Changed to 200 instead of 204
        exit();
    }
}
