-- Add payment frequency support for feeding system
-- This allows students to pay weekly or monthly for feeding

-- Add payment_frequency column to students table
ALTER TABLE students 
ADD COLUMN IF NOT EXISTS feeding_payment_frequency ENUM('weekly', 'monthly') DEFAULT 'weekly' AFTER custom_feeding_fee;

-- Add monthly_fee_balance column to track remaining balance for monthly payers
ALTER TABLE students 
ADD COLUMN IF NOT EXISTS feeding_monthly_balance DECIMAL(10,2) DEFAULT 0.00 AFTER feeding_payment_frequency;

-- Add last_monthly_payment_date to track when monthly payment was made
ALTER TABLE students 
ADD COLUMN IF NOT EXISTS feeding_last_monthly_payment DATE NULL AFTER feeding_monthly_balance;
