<?php
/**
 * Alternative Academic System Database Setup
 * Use this if setup_academic_system.php doesn't work
 */

// Production Database configuration
$host = 'localhost';
$username = 'campuspl_pcg';
$password = 'pcgcctt@30';
$database = 'campuspl_dgsch';

echo "🎓 Initializing Academic System Database...\n\n";

try {
    // Connect to database
    $conn = new mysqli($host, $username, $password, $database);
    
    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }
    
    echo "✅ Connected to database: $database\n\n";
    
    // Read SQL file
    $sqlFile = __DIR__ . '/create_academic_tables.sql';
    
    if (!file_exists($sqlFile)) {
        throw new Exception("SQL file not found: $sqlFile");
    }
    
    $sql = file_get_contents($sqlFile);
    
    // Execute multi-query
    if ($conn->multi_query($sql)) {
        do {
            // Store first result set
            if ($result = $conn->store_result()) {
                $result->free();
            }
            
            // Check for errors
            if ($conn->errno) {
                echo "⚠️  Warning: " . $conn->error . "\n";
            }
            
        } while ($conn->more_results() && $conn->next_result());
    }
    
    echo "\n" . str_repeat("=", 50) . "\n";
    echo "✅ Academic System Setup Complete!\n";
    echo str_repeat("=", 50) . "\n\n";
    
    // Verify tables
    echo "🔍 Verifying tables...\n";
    $tables = [
        'academic_terms',
        'classes',
        'subjects',
        'class_subjects',
        'assessment_types',
        'assessments',
        'student_scores',
        'grading_scale',
        'attendance',
        'subject_attendance',
        'report_cards',
        'report_card_details'
    ];
    
    foreach ($tables as $table) {
        $result = $conn->query("SHOW TABLES LIKE '$table'");
        if ($result->num_rows > 0) {
            // Get row count
            $countResult = $conn->query("SELECT COUNT(*) as count FROM $table");
            $count = $countResult->fetch_assoc()['count'];
            echo "✅ $table ($count rows)\n";
        } else {
            echo "❌ $table (missing)\n";
        }
    }
    
    $conn->close();
    
    echo "\n🎉 Academic System is ready to use!\n";
    echo "\nNext steps:\n";
    echo "1. Access your application\n";
    echo "2. Login as admin\n";
    echo "3. Click 'Academics' in the sidebar\n";
    echo "4. Start managing classes and subjects!\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    exit(1);
}
