<?php
// Production Database configuration
$servername = "localhost";
$username = "campuspl_pcg";
$password = "pcgcctt@30";
$dbname = "campuspl_dgsch";

try {
    // Create connection without database
    $conn = new PDO("mysql:host=$servername", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Create database if not exists
    $sql = "CREATE DATABASE IF NOT EXISTS $dbname CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";
    $conn->exec($sql);
    echo "Database created successfully or already exists<br>";
    
    // Select the database
    $conn->exec("USE $dbname");
    
    // Drop existing tables in reverse order to avoid foreign key constraints
    $dropTables = [
        'audit_logs',
        'fees',
        'expenses',
        'income',
        'students',
        'users'
    ];
    
    $conn->exec("SET FOREIGN_KEY_CHECKS=0");
    foreach ($dropTables as $table) {
        try {
            $conn->exec("DROP TABLE IF EXISTS `$table`");
            echo "Dropped table $table (if it existed)<br>";
        } catch (PDOException $e) {
            echo "Note: Could not drop $table - " . $e->getMessage() . "<br>";
        }
    }
    $conn->exec("SET FOREIGN_KEY_CHECKS=1");
    
    // Create tables one by one with error handling
    $tables = [
        // Users table must be created first
        "CREATE TABLE IF NOT EXISTS `users` (
            `id` INT AUTO_INCREMENT PRIMARY KEY,
            `username` VARCHAR(50) UNIQUE NOT NULL,
            `password` VARCHAR(255) NOT NULL,
            `email` VARCHAR(100) UNIQUE NOT NULL,
            `full_name` VARCHAR(100) NOT NULL,
            `role` ENUM('admin', 'accountant', 'teacher', 'staff') NOT NULL DEFAULT 'staff',
            `last_login` DATETIME,
            `status` ENUM('active', 'inactive') DEFAULT 'active',
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
        
        // Students table
        "CREATE TABLE IF NOT EXISTS `students` (
            `id` INT AUTO_INCREMENT PRIMARY KEY,
            `student_id` VARCHAR(50) UNIQUE NOT NULL,
            `first_name` VARCHAR(50) NOT NULL,
            `last_name` VARCHAR(50) NOT NULL,
            `date_of_birth` DATE NOT NULL,
            `gender` ENUM('Male', 'Female', 'Other') NOT NULL,
            `class` VARCHAR(20) NOT NULL,
            `section` VARCHAR(10) NOT NULL,
            `admission_date` DATE NOT NULL,
            `father_name` VARCHAR(100),
            `mother_name` VARCHAR(100),
            `phone_number` VARCHAR(20),
            `address` TEXT,
            `city` VARCHAR(50),
            `state` VARCHAR(50),
            `pincode` VARCHAR(20),
            `status` ENUM('Active', 'Inactive', 'Graduated', 'Transferred') DEFAULT 'Active',
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
        
        // Fees table (depends on students)
        "CREATE TABLE IF NOT EXISTS `fees` (
            `id` INT AUTO_INCREMENT PRIMARY KEY,
            `student_id` INT NOT NULL,
            `fee_type` ENUM('Admission', 'Monthly', 'Exam', 'Transport', 'Other') NOT NULL,
            `amount` DECIMAL(10, 2) NOT NULL,
            `due_date` DATE NOT NULL,
            `status` ENUM('Paid', 'Unpaid', 'Partial', 'Overdue') DEFAULT 'Unpaid',
            `payment_date` DATE,
            `payment_method` VARCHAR(50),
            `transaction_id` VARCHAR(100),
            `discount` DECIMAL(10, 2) DEFAULT 0.00,
            `fine` DECIMAL(10, 2) DEFAULT 0.00,
            `notes` TEXT,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (`student_id`) REFERENCES `students`(`id`) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
        
        // Expenses table
        "CREATE TABLE IF NOT EXISTS `expenses` (
            `id` INT AUTO_INCREMENT PRIMARY KEY,
            `category` VARCHAR(50) NOT NULL,
            `amount` DECIMAL(10, 2) NOT NULL,
            `expense_date` DATE NOT NULL,
            `description` TEXT,
            `payment_method` VARCHAR(50),
            `reference_number` VARCHAR(100),
            `created_by` INT,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (`created_by`) REFERENCES `users`(`id`) ON DELETE SET NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
        
        // Income table
        "CREATE TABLE IF NOT EXISTS `income` (
            `id` INT AUTO_INCREMENT PRIMARY KEY,
            `source` VARCHAR(100) NOT NULL,
            `amount` DECIMAL(10, 2) NOT NULL,
            `income_date` DATE NOT NULL,
            `description` TEXT,
            `payment_method` VARCHAR(50),
            `reference_number` VARCHAR(100),
            `received_by` INT,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (`received_by`) REFERENCES `users`(`id`) ON DELETE SET NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
        
        // Audit logs table (depends on users)
        "CREATE TABLE IF NOT EXISTS `audit_logs` (
            `id` INT AUTO_INCREMENT PRIMARY KEY,
            `user_id` INT,
            `action` VARCHAR(50) NOT NULL,
            `table_name` VARCHAR(50) NOT NULL,
            `record_id` INT,
            `old_values` TEXT,
            `new_values` TEXT,
            `ip_address` VARCHAR(45),
            `user_agent` TEXT,
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE SET NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;"
    ];
    
    // Execute table creation queries
    foreach ($tables as $query) {
        try {
            $conn->exec($query);
            echo "Table created successfully<br>";
        } catch (PDOException $e) {
            die("Error creating table: " . $e->getMessage() . "<br>");
        }
    }
    
    // Insert default admin user
    try {
        $adminPassword = password_hash('admin123', PASSWORD_DEFAULT);
        $insertAdmin = $conn->prepare("
            INSERT INTO `users` 
            (`username`, `password`, `email`, `full_name`, `role`, `status`)
            VALUES (?, ?, ?, ?, 'admin', 'active')");
        $insertAdmin->execute(['admin', $adminPassword, 'admin@divinegrace.edu', 'Administrator']);
        echo "Admin user created successfully<br>";
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate entry') === false) {
            die("Error creating admin user: " . $e->getMessage() . "<br>");
        }
        echo "Admin user already exists<br>";
    }
    
    echo "Database tables created successfully<br>";
    
    // Test connection to the new database
    $testQuery = $conn->query("SELECT COUNT(*) as count FROM users WHERE username = 'admin'");
    $result = $testQuery->fetch(PDO::FETCH_ASSOC);
    
    if ($result['count'] > 0) {
        echo "<h2>✅ Database setup completed successfully!</h2>";
        echo "<p>Default admin user created:</p>";
        echo "<ul>";
        echo "<li>Username: admin</li>";
        echo "<li>Password: admin123</li>";
        echo "<li>Email: admin@divinegrace.edu</li>";
        echo "</ul>";
        echo "<p>Please change the default password after first login.</p>";
    } else {
        echo "<h2>⚠️ Database setup completed with warnings</h2>";
        echo "<p>Default admin user might not have been created.</p>";
    }
    
} catch(PDOException $e) {
    die("<h2>❌ Database setup failed:</h2><p>" . $e->getMessage() . "</p>");
}
?>
