<?php
/**
 * Migration script to add missing columns to the fees table
 */

// Production Database configuration
$host = getenv('DB_HOST') ?: 'localhost';
$user = getenv('DB_USER') ?: 'campuspl_pcg';
$pass = getenv('DB_PASS') ?: 'pcgcctt@30';
$dbname = getenv('DB_NAME') ?: 'campuspl_dgsch';

try {
    // Connect to database
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "Starting migration: Adding missing columns to fees table...\n";
    
    // Add missing columns to fees table
    $queries = [
        "ALTER TABLE `fees` 
         ADD COLUMN `original_amount` DECIMAL(10, 2) NULL AFTER `amount`,
         ADD COLUMN `student_name` VARCHAR(100) NULL AFTER `student_id`,
         ADD COLUMN `student_id_num` VARCHAR(50) NULL AFTER `student_name`,
         ADD COLUMN `description` TEXT NULL AFTER `original_amount`,
         ADD COLUMN `academic_year` VARCHAR(20) NULL AFTER `description`,
         ADD COLUMN `term` VARCHAR(20) NULL AFTER `academic_year`,
         ADD COLUMN `recorded_by` INT NULL AFTER `payment_method`,
         ADD COLUMN `is_active` TINYINT(1) DEFAULT 1 AFTER `recorded_by`,
         ADD COLUMN `deleted_at` TIMESTAMP NULL DEFAULT NULL AFTER `is_active`,
         ADD INDEX `idx_student_id` (`student_id`),
         ADD INDEX `idx_status` (`status`),
         ADD INDEX `idx_due_date` (`due_date`)"
    ];
    
    // Execute each query
    foreach ($queries as $query) {
        echo "Executing: " . substr($query, 0, 60) . "...\n";
        $pdo->exec($query);
    }
    
    // If we have existing data, set default values for the new columns
    $pdo->exec("UPDATE `fees` SET 
        `original_amount` = `amount`,
        `is_active` = 1
        WHERE `original_amount` IS NULL");
    
    echo "Migration completed successfully!\n";
    
} catch (PDOException $e) {
    die("Migration failed: " . $e->getMessage() . "\n");
}
