<?php
/**
 * Migration: Add scholarship support for feeding system
 */

require_once __DIR__ . '/../config/database.php';

try {
    echo "Starting feeding scholarship migration...\n";
    
    // Add scholarship column
    echo "Adding feeding_scholarship column to students table...\n";
    $conn->exec("
        ALTER TABLE students 
        ADD COLUMN IF NOT EXISTS feeding_scholarship BOOLEAN DEFAULT FALSE AFTER feeding_last_monthly_payment
    ");
    echo "✓ Added feeding_scholarship column\n";
    
    // Add scholarship note column
    echo "Adding feeding_scholarship_note column to students table...\n";
    $conn->exec("
        ALTER TABLE students 
        ADD COLUMN IF NOT EXISTS feeding_scholarship_note VARCHAR(255) NULL AFTER feeding_scholarship
    ");
    echo "✓ Added feeding_scholarship_note column\n";
    
    echo "\n✅ Migration completed successfully!\n";
    echo "\nFeeding Scholarship Feature:\n";
    echo "- Students can now be marked as scholarship recipients\n";
    echo "- Scholarship students don't pay for feeding\n";
    echo "- Optional note field for scholarship details\n";
    
} catch (PDOException $e) {
    echo "❌ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
