<?php
/**
 * Migration: Add is_active and phone columns to users table
 */

// Database configuration - Auto-detect environment
$isProduction = isset($_SERVER['HTTP_HOST']) && (
    strpos($_SERVER['HTTP_HOST'], 'ceiscy.com') !== false ||
    strpos($_SERVER['HTTP_HOST'], 'pcg.campus-plug.com') !== false
);

if ($isProduction) {
    // Production database
    $servername = "localhost";
    $username = "campuspl_pcg";
    $password = "pcgcctt@30";
    $dbname = "campuspl_dgsch";
} else {
    // Local development database
    $servername = "localhost";
    $username = "root";
    $password = "";
    $dbname = "divine_grace_school";
}

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "Connected successfully to database: $dbname\n\n";
    
    // Check if columns already exist
    $stmt = $conn->query("SHOW COLUMNS FROM users LIKE 'is_active'");
    $hasIsActive = $stmt->rowCount() > 0;
    
    $stmt = $conn->query("SHOW COLUMNS FROM users LIKE 'phone'");
    $hasPhone = $stmt->rowCount() > 0;
    
    // Add is_active column if it doesn't exist
    if (!$hasIsActive) {
        echo "Adding is_active column...\n";
        $conn->exec("ALTER TABLE users ADD COLUMN is_active TINYINT(1) DEFAULT 1 AFTER role");
        echo "✓ is_active column added successfully\n";
    } else {
        echo "✓ is_active column already exists\n";
    }
    
    // Add phone column if it doesn't exist
    if (!$hasPhone) {
        echo "Adding phone column...\n";
        $conn->exec("ALTER TABLE users ADD COLUMN phone VARCHAR(20) AFTER email");
        echo "✓ phone column added successfully\n";
    } else {
        echo "✓ phone column already exists\n";
    }
    
    // Update role enum to include all roles
    echo "\nUpdating role enum values...\n";
    $conn->exec("ALTER TABLE users MODIFY COLUMN role ENUM('admin', 'teacher', 'accountant', 'finance', 'principal') DEFAULT 'teacher'");
    echo "✓ Role enum updated successfully\n";
    
    // Set all existing users to active if not already set
    echo "\nSetting existing users to active...\n";
    $conn->exec("UPDATE users SET is_active = 1 WHERE is_active IS NULL");
    echo "✓ Existing users set to active\n";
    
    echo "\n✅ Migration completed successfully!\n";
    
} catch(PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
