<?php
/**
 * Transport System Setup Script
 * Run this once to create all transport-related tables
 */

require_once __DIR__ . '/../api/config.php';

try {
    $conn = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "Setting up Transport System...\n\n";
    
    // Read and execute SQL file
    $sql = file_get_contents(__DIR__ . '/create_transport_tables.sql');
    
    // Split by semicolon and execute each statement
    $statements = array_filter(array_map('trim', explode(';', $sql)));
    
    foreach ($statements as $statement) {
        if (!empty($statement)) {
            try {
                $conn->exec($statement);
                echo "✓ Executed statement\n";
            } catch (PDOException $e) {
                echo "✗ Error: " . $e->getMessage() . "\n";
            }
        }
    }
    
    echo "\n✅ Transport System setup completed successfully!\n";
    echo "\nTables created:\n";
    echo "- transport_routes\n";
    echo "- route_stops\n";
    echo "- transport_vehicles\n";
    echo "- transport_drivers\n";
    echo "- route_assignments\n";
    echo "- student_transport\n";
    echo "- transport_attendance\n";
    echo "- transport_payments\n";
    echo "- fuel_logs\n";
    echo "- trip_logs\n";
    
} catch (PDOException $e) {
    echo "❌ Database Error: " . $e->getMessage() . "\n";
    exit(1);
}
?>
