<?php
/**
 * Update payment frequency to support daily, weekly, and monthly
 */

require_once __DIR__ . '/../config/database.php';

try {
    echo "Updating payment frequency options...\n";
    
    // Update the ENUM to include 'daily'
    $conn->exec("
        ALTER TABLE students 
        MODIFY COLUMN feeding_payment_frequency ENUM('daily', 'weekly', 'monthly') DEFAULT 'daily'
    ");
    
    echo "✅ Payment frequency updated to support daily, weekly, and monthly\n";
    
    // Update existing 'weekly' records to 'daily' as default
    $conn->exec("UPDATE students SET feeding_payment_frequency = 'daily' WHERE feeding_payment_frequency IS NULL");
    
    echo "✅ Set default payment frequency to 'daily' for all students\n";
    
} catch (PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    exit(1);
}
